local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
--local Pulse = THEME:GetMetric("Combo", "PulseCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local t = Def.ActorFrame {
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor("_label") .. {
		Name="ComboLabel";
		InitCommand=cmd(pause);
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
		c.ComboLabel:visible(false);
	end;

	-- todo: find out why the miss label/number shows up on goods; technically
	-- they shouldn't be showing up but I dunno I'm too fucking lazy to work
	-- around it.
	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			c.ComboLabel:visible(false);
			return;
		end

		local Label = c.ComboLabel;
		local bComboOrMiss = false;
		if param.Combo then
			Label:setstate(0);
			bComboOrMiss = true;
		elseif param.Misses then
			Label:setstate(1);
			bComboOrMiss = true;
		end
		-- reset the label's visibility so we don't accidentally draw both labels
		Label:visible(false);

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );
		
		if bComboOrMiss then
			c.Number:visible(true);
			Label:visible(true);
		end;

		c.Number:settext( string.format("%i", iCombo) );

		local Pulse = function(self)
			self:stoptweening();
			
			local GlowStart;
			local GlowEnd;
			local StartAlpha = 0.5;
			if param.Combo then
				GlowColor = color("1,0.8,0,"..StartAlpha);
				GlowEnd = color("1,0.8,0,0");
			else
				GlowColor = color("1,0,0,"..StartAlpha);
				GlowEnd = color("1,0,0,0");
			end;
			
			self:glow(GlowColor);
			self:smooth(0.1);
			self:glow(GlowEnd);
		end;
		
		Pulse( c.Number, param );
		-- don't play command on label, it gets distracting
		--Pulse( Label, param );
	end;
};

return t;
